/*************************************************************************
*FILE: cypress_i2c.h
*SW-COMPONENT: cypress touch driver
*DESCRIPTION: header file for the i2c functionalities used by cypress driver.
*COPYRIGHT: (C) 2020 Robert Bosch GmbH. All Rights Reserved. Confidential.
* This software is licensed under the terms of the End User License
* Agreement (EULA) of Robert Bosch GmbH. Any use is subject
* to agreement and compliance with such EULA, as applicable.
***************************************************************************/
#include <stdint.h>

#ifndef CYPRESS_I2C_H
#define CYPRESS_I2C_H

#ifdef  __cplusplus
extern "C" {
#endif


int cypress_i2c_open(char* i2c_devname, unsigned slave_id, unsigned i2c_speed);
void cypress_i2c_close(int fd);
int cypress_read_reg(int fd, uint16_t reg, uint16_t len, void* buf);
int cypress_write_reg(int fd, uint16_t reg, uint16_t len, const void *val);

typedef struct {
    int (*open)(char* i2c_devname, unsigned slave_id, unsigned i2c_speed);
    void (*close)(int fd);
    int (*read_reg)(int fd, uint16_t reg, uint16_t len, void* buf);
    int (*write_reg)(int fd, uint16_t reg, uint16_t len, const void *val);
} qc_i2c_funcs_t;

int get_qc_libi2c_funcs(const char* libname, qc_i2c_funcs_t* funcs);

#ifdef  __cplusplus
}
#endif

#endif /* CYPRESS_I2C_H */
